from django.db import models

class Brand(models.Model): # app.products
    brand_name = models.CharField(max_length=50)
    brand_img = models.CharField(max_length=300)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class Category(models.Model):  # app.products
    category_name = models.CharField(max_length=50)
    category_img = models.CharField(max_length=300)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class Product(models.Model):  # app.products
    title = models.CharField(max_length=200)
    short_des = models.CharField(max_length=500)
    price = models.CharField(max_length=50)
    points = models.IntegerField()
    discount = models.BooleanField()
    discount_price = models.CharField(max_length=50)
    image = models.CharField(max_length=200)
    stock = models.BooleanField()
    star = models.FloatField()
    remark = models.CharField(max_length=10, choices=[('popular','popular'),('new','new'),('top','top'),('special','special'),('trending','trending'),('regular','regular')])
    category = models.ForeignKey(Category, on_delete=models.RESTRICT, null=True, blank=True)
    brand = models.ForeignKey(Brand, on_delete=models.RESTRICT, null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class ProductDetails(models.Model):  # app.products
    img1 = models.CharField(max_length=200)
    img2 = models.CharField(max_length=200)
    img3 = models.CharField(max_length=200)
    img4 = models.CharField(max_length=200)
    des = models.TextField()
    color = models.CharField(max_length=200)
    size = models.CharField(max_length=200)
    product = models.OneToOneField(Product, on_delete=models.RESTRICT)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class ProductReview(models.Model):   # app.products
    description = models.CharField(max_length=1000)
    rating = models.CharField(max_length=10)
    user = models.ForeignKey(User, on_delete=models.RESTRICT, null=True, blank=True)
    product = models.ForeignKey(Product, on_delete=models.RESTRICT, null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)


class ProductSliders(models.Model):  # app.main
    title = models.CharField(max_length=200)
    short_des = models.CharField(max_length=500)
    price = models.CharField(max_length=100)
    image = models.CharField(max_length=200)
    product = models.OneToOneField(Product, on_delete=models.RESTRICT)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)


class User(models.Model):   # app.accounts
    phone = models.CharField(max_length=100, unique=True)
    email = models.CharField(max_length=100, unique=True)
    points = models.IntegerField()
    amount = models.IntegerField()
    referral_code = models.CharField(max_length=100, unique=True)
    otp = models.CharField(max_length=10)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)



class CustomerProfile(models.Model):   # app.customers
    cus_name = models.CharField(max_length=100)
    cus_add = models.CharField(max_length=500)
    cus_city = models.CharField(max_length=50)
    cus_state = models.CharField(max_length=50)
    cus_postcode = models.CharField(max_length=50)
    cus_country = models.CharField(max_length=50)
    cus_phone = models.CharField(max_length=50)
    cus_fax = models.CharField(max_length=50)
    ship_name = models.CharField(max_length=100)
    ship_add = models.CharField(max_length=100)
    ship_city = models.CharField(max_length=100)
    ship_state = models.CharField(max_length=100)
    ship_postcode = models.CharField(max_length=100)
    ship_country = models.CharField(max_length=100)
    ship_phone = models.CharField(max_length=50)
    user = models.OneToOneField(User, on_delete=models.RESTRICT, unique=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)



class Wishlist(models.Model):   # app.orders
    product = models.ForeignKey(Product, on_delete=models.RESTRICT)
    user = models.ForeignKey(User, on_delete=models.RESTRICT)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class Cart(models.Model):   # app.orders
    user = models.ForeignKey(User, on_delete=models.RESTRICT)
    product = models.ForeignKey(Product, on_delete=models.RESTRICT)
    color = models.CharField(max_length=200)
    size = models.CharField(max_length=200)
    qty = models.CharField(max_length=200)
    price = models.CharField(max_length=200)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class Order(models.Model):   # app.orders
    total = models.CharField(max_length=50)
    vat = models.CharField(max_length=50)
    payable = models.CharField(max_length=50)
    cus_details = models.CharField(max_length=500)
    ship_details = models.CharField(max_length=500)
    tran_id = models.CharField(max_length=100)
    val_id = models.CharField(max_length=100, default='0')
    delivery_status = models.CharField(max_length=10, choices=[('Pending','Pending'),('Processing','Processing'),('Completed','Completed')])
    payment_status = models.CharField(max_length=255)
    user = models.ForeignKey(User, on_delete=models.RESTRICT)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class OrderItem(models.Model):   # app.orders
    order = models.ForeignKey(Order, on_delete=models.RESTRICT)
    product = models.ForeignKey(Product, on_delete=models.RESTRICT)
    user = models.ForeignKey(User, on_delete=models.RESTRICT)
    qty = models.CharField(max_length=50)
    sale_price = models.CharField(max_length=50)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class AmountExpenses(models.Model):   # app.customers
    is_withdraw = models.BooleanField(default=False)
    is_purchase = models.BooleanField(default=False)
    is_done = models.BooleanField(default=False)
    type = models.CharField(max_length=100, unique=True)
    user = models.ForeignKey(User, on_delete=models.RESTRICT)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class Commission(models.Model):   # app.customers
    type = models.CharField(max_length=255)
    commission_percent = models.DecimalField(max_digits=5, decimal_places=2, unsigned=True)
    commission_amount = models.DecimalField(max_digits=10, decimal_places=2, unsigned=True)
    generation = models.IntegerField()
    order = models.ForeignKey(Order, on_delete=models.RESTRICT)
    user = models.ForeignKey(User, on_delete=models.RESTRICT)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class Referral(models.Model):   # app.customers
    user = models.ForeignKey(User, on_delete=models.RESTRICT)
    referrer = models.ForeignKey(User, on_delete=models.RESTRICT, related_name='referrer')
    level = models.IntegerField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class Coupon(models.Model):    # app.customers
    prize = models.CharField(max_length=255)
    used_points = models.IntegerField()
    coupon_code = models.CharField(max_length=255)
    opened_by = models.ForeignKey(User, on_delete=models.RESTRICT)
    open_date = models.DateField()
    is_enabled = models.BooleanField(default=False)
    prize_given = models.BooleanField(default=False)
    expiry_date = models.DateField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class Winner(models.Model):   # app.customers
    position = models.IntegerField()
    prize = models.CharField(max_length=255)
    prize_given = models.BooleanField(default=False)
    prize_given_to = models.ForeignKey(User, on_delete=models.RESTRICT)
    prize_given_date = models.DateField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class Reseller(models.Model):   # app.resellers
    reseller_name = models.CharField(max_length=255)
    reseller_email = models.CharField(max_length=255, null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class ResellerProductPrice(models.Model):   # app.resellers
    reseller = models.ForeignKey(Reseller, on_delete=models.RESTRICT)
    product = models.ForeignKey(Product, on_delete=models.RESTRICT)
    reseller_price = models.DecimalField(max_digits=10, decimal_places=2)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class ResellerOrder(models.Model):   # app.resellers
    reseller = models.ForeignKey(Reseller, on_delete=models.RESTRICT)
    order_date = models.DateField()
    total_amount = models.DecimalField(max_digits=10, decimal_places=2)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class ResellerOrderItem(models.Model):   # app.resellers
    order = models.ForeignKey(ResellerOrder, on_delete=models.RESTRICT)
    product = models.ForeignKey(Product, on_delete=models.RESTRICT)
    reseller_product = models.ForeignKey(ResellerProductPrice, on_delete=models.RESTRICT)
    quantity = models.IntegerField()
    unit_price = models.DecimalField(max_digits=10, decimal_places=2)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
