from django.urls import path
from .views import *

urlpatterns = [
    # Read All
    path('', reseller_list, name='reseller_list'),

    path('orders/', reseller_order_list, name='reseller_order_list'),


    # Create
    path('create/', reseller_create, name='reseller_create'),
    path('store/', reseller_store, name='reseller_store'),

    # Read one
    path('<int:reseller_id>/', reseller_show, name='reseller_show'),

    # Update
    path('<int:reseller_id>/edit/', reseller_edit, name='reseller_edit'),
    path('<int:reseller_id>/update/', reseller_update, name='reseller_update'),

    # Delete
    path('<int:reseller_id>/destroy/', reseller_destroy, name='reseller_destroy'),

    path('request-list/', reseller_request_list, name='reseller_request_list'),

    path('request-list/cancel/', reseller_request_cancel_list, name='reseller_request_cancel_list'),

    path('shop/', reseller_shop, name='reseller_shop'),

    path('cart-page/',reseller_cart_page, name='reseller_cart_page'),

    path('checkout/',reseller_checkout, name='reseller_checkout'),


    
    path('customer/reseller/create/', customer_reseller_create, name='customer_reseller_create'),
    path('customer/reseller/store/', customer_reseller_store, name='customer_reseller_store'),

    path('customer/reseller/profile/', customer_reseller_profile, name='customer_reseller_profile'),

    path('customer/reseller/order/', customer_reseller_order_list, name='customer_reseller_order_list'),


]
