from django.db import models
from apps.products.models import *
from django.contrib.auth import get_user_model
# Create your models here.
CustomUser = get_user_model() 
class Reseller(models.Model):   # app.resellers
    status = models.CharField(max_length=10, choices=[ ('pending','Pending'), ('approved','Approved'),('cancel','cancel')], default = 'pending')
    
    full_name = models.CharField(max_length=255)
    email = models.CharField(max_length=255, null=True, blank=True)
    address = models.TextField(null=True, blank=True)
    details = models.TextField(null=True, blank=True)


    user = models.OneToOneField(CustomUser, on_delete=models.RESTRICT, null=True, blank=True)

    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

# class ResellerProductPrice(models.Model):   # app.resellers
#     reseller = models.ForeignKey(Reseller, on_delete=models.RESTRICT)
#     product = models.ForeignKey(Product, on_delete=models.RESTRICT)
#     reseller_price = models.DecimalField(max_digits=10, decimal_places=2)
#     created_at = models.DateTimeField(auto_now_add=True)
#     updated_at = models.DateTimeField(auto_now=True)

# class ResellerOrder(models.Model):   # app.resellers
#     reseller = models.ForeignKey(Reseller, on_delete=models.RESTRICT)
#     order_date = models.DateField()
#     total_amount = models.DecimalField(max_digits=10, decimal_places=2)
#     created_at = models.DateTimeField(auto_now_add=True)
#     updated_at = models.DateTimeField(auto_now=True)

# class ResellerOrderItem(models.Model):   # app.resellers
#     order = models.ForeignKey(ResellerOrder, on_delete=models.RESTRICT)
#     product = models.ForeignKey(Product, on_delete=models.RESTRICT)
#     reseller_product = models.ForeignKey(ResellerProductPrice, on_delete=models.RESTRICT)
#     quantity = models.IntegerField()
#     unit_price = models.DecimalField(max_digits=10, decimal_places=2)
#     created_at = models.DateTimeField(auto_now_add=True)
#     updated_at = models.DateTimeField(auto_now=True)