from django.shortcuts import get_object_or_404, render, redirect
from django.views.decorators.http import require_GET, require_POST, require_http_methods
from .forms import *
from .models import Product


# *********************** Products view ************************

@require_GET
def product_index(request):
    products = Product.objects.all()
    return render(request, 'panel/page/product/product_list.html', {'products': products})

@require_GET
def product_create(request):
    form = ProductForm()
    return render(request, 'panel/page/product/add_product.html', {'form': form})

@require_POST
def product_store(request):
    form = ProductForm(request.POST, request.FILES)
    if form.is_valid():
        product = form.save()
        return redirect('product_list')
    return render(request, 'panel/page/product/add_product.html', {'form': form})

@require_GET
def product_show(request, product_id):
    product = get_object_or_404(Product, pk=product_id)
    return render(request, 'panel/page/product/product_show.html', {'product': product})

@require_GET
def product_edit(request, product_id):
    product = get_object_or_404(Product, pk=product_id)
    form = ProductForm(instance=product)
    return render(request, 'panel/page/product/edit_product.html', {'form': form, 'product': product})

@require_POST
def product_update(request, product_id):
    product = get_object_or_404(Product, pk=product_id)
    form = ProductForm(request.POST, request.FILES, instance=product)
    if form.is_valid():
        form.save()
        return redirect('product_list')
    return render(request, 'panel/page/product/edit_product.htmll', {'form': form, 'product': product})

@require_POST
def product_destroy(request, product_id):
    product = get_object_or_404(Product, pk=product_id)
    product.delete()
    return redirect('product_index')




@require_GET
def brand_index(request):
    brands = Brand.objects.all()
    return render(request, 'panel/page/brand/brand_list.html', {'brands': brands})

@require_GET
def brand_create(request):
    form = BrandForm()
    return render(request, 'panel/page/brand/add_brand.html', {'form': form})

@require_POST
def brand_store(request):
    form = BrandForm(request.POST, request.FILES)
    if form.is_valid():
        brand = form.save()
        return redirect('brand_show', brand_id=brand.id)
    return render(request, 'panel/page/brand/add_brand.html', {'form': form})

@require_GET
def brand_show(request, brand_id):
    brand = get_object_or_404(Brand, pk=brand_id)
    return render(request, 'panel/page/brand/brand_show.html', {'brand': brand})

@require_GET
def brand_edit(request, brand_id):
    brand = get_object_or_404(Brand, pk=brand_id)
    form = BrandForm(instance=brand)
    return render(request, 'panel/page/brand/edit_brand.html', {'form': form, 'brand': brand})

@require_POST
def brand_update(request, brand_id):
    brand = get_object_or_404(Brand, pk=brand_id)
    form = BrandForm(request.POST, request.FILES, instance=brand)
    if form.is_valid():
        form.save()
        return redirect('brand_show', brand_id=brand.id)
    return render(request, 'panel/page/brand/edit_brand.html', {'form': form, 'brand': brand})

@require_POST
def brand_destroy(request, brand_id):
    brand = get_object_or_404(Brand, pk=brand_id)
    brand.delete()
    return redirect('brand_index')










@require_GET
def category_index(request):
    categories = Category.objects.all()
    return render(request, 'panel/page/category/category_list.html', {'categories': categories})

@require_GET
def category_create(request):
    form = CategoryForm()
    return render(request, 'panel/page/category/add_category.html', {'form': form})

@require_POST
def category_store(request):
    form = CategoryForm(request.POST, request.FILES)
    if form.is_valid():
        category = form.save()
        return redirect('category_show', category_id=category.id)
    return render(request, 'panel/page/category/add_category.html', {'form': form})

@require_GET
def category_show(request, category_id):
    category = get_object_or_404(Category, pk=category_id)
    return render(request, 'panel/page/category/category_show.html', {'category': category})

@require_GET
def category_edit(request, category_id):
    category = get_object_or_404(Category, pk=category_id)
    form = CategoryForm(instance=category)
    return render(request, 'panel/page/category/edit_category.html', {'form': form, 'category': category})

@require_POST
def category_update(request, category_id):
    category = get_object_or_404(Category, pk=category_id)
    form = CategoryForm(request.POST,request.FILES, instance=category)
    if form.is_valid():
        form.save()
        return redirect('category_index')
    return render(request, 'panel/page/category/edit_category.html', {'form': form, 'category': category})

@require_POST
def category_destroy(request, category_id):
    category = get_object_or_404(Category, pk=category_id)
    category.delete()
    return redirect('category_index')







# Create your views here.

def compare(request):
    return render(request, 'site/products/compare.html')


def faq(request):
    return render(request, 'site/faq.html')

def blog_grid(request):
    return render(request, 'site/blog_grid.html')

def blog_standard(request):
    return render(request, 'site/blog_standard.html')

def blog_details(request):
    return render(request, 'site/blog_details.html')

def page_not_found(request, exception):
    return render(request, "site/404.html")