import datetime

from apps.products.models import *


def create_brands():
    brands = [
        {
            "name": "Nike",
            "img": "/brand/01.jpg",
            "details": "Leading sportswear brand"
        },
        {
            "name": "Adidas",
            "img": "/brand/02.jpg",
            "details": "Innovative athletic apparel and accessories"
        },
        {
            "name": "Apple",
            "img": "/brand/03.jpg",
            "details": "Iconic technology brand"
        },
        {
            "name": "Kellogg's",
            "img": "/brand/04.jpg",
            "details": "Well-known for breakfast cereals and snacks"
        },
        {
            "name": "Campbell's",
            "img": "/brand/05.jpg",
            "details": "Famous for canned soups and other convenience foods"
        },
        {
            "name": "Heinz",
            "img": "/brand/06.jpg",
            "details": "Renowned for ketchup, condiments, and canned foods"
        },
        {
            "name": "Nestlé",
            "img": "/brand/01.jpg",
            "details": "Global food and beverage conglomerate"
        },
        {
            "name": "General Mills",
            "img": "/brand/02.jpg",
            "details": "Produces popular cereal brands and other consumer foods"
        },
        {
            "name": "Kraft",
            "img": "/brand/03.jpg",
            "details": "Well-known for cheese, dairy, and grocery products"
        },
        {
            "name": "Hershey's",
            "img": "/brand/04.jpg",
            "details": "Famous for chocolate and confectionery products"
        },
        {
            "name": "Coca-Cola",
            "img": "/brand/05.jpg",
            "details": "One of the world's largest beverage companies"
        },
        {
            "name": "PepsiCo",
            "img": "/brand/06.jpg",
            "details": "Diverse portfolio including beverages and snacks"
        },
        {
            "name": "Unilever",
            "img": "/brand/01.jpg",
            "details": "Global consumer goods company with various food brands"
        },
        {
            "name": "Procter & Gamble",
            "img": "/brand/02.jpg",
            "details": "Multinational consumer goods corporation with various household and personal care products"
        },
        {
            "name": "Quaker Oats",
            "img": "/brand/03.jpg",
            "details": "Well-known for oatmeal and breakfast foods"
        },
        {
            "name": "Hormel Foods",
            "img": "/brand/04.jpg",
            "details": "Produces a variety of meat and food products"
        },
        {
            "name": "McCormick & Company",
            "img": "/brand/05.jpg",
            "details": "Leading spice and seasoning manufacturer"
        },
        {
            "name": "Ocean Spray",
            "img": "/brand/06.jpg",
            "details": "Produces cranberry and fruit-based products"
        },
        {
            "name": "J.M. Smucker Company",
            "img": "/brand/01.jpg",
            "details": "Produces fruit spreads, peanut butter, and other food products"
        },
        {
            "name": "Dole Food Company",
            "img": "/brand/02.jpg",
            "details": "Produces fresh fruits, vegetables, and packaged foods"
        },
        {
            "name": "Conagra Brands",
            "img": "/brand/03.jpg",
            "details": "Diverse portfolio including frozen foods, snacks, and condiments"
        },
        {
            "name": "Nabisco",
            "img": "/brand/04.jpg",
            "details": "Well-known for cookies and snacks"
        },
        {
            "name": "Frito-Lay",
            "img": "/brand/05.jpg",
            "details": "Leading producer of snacks, including chips and pretzels"
        }
    ]

    for brand in brands:
        Brand.objects.create(
            name=brand["name"],
            img=brand["img"],
            details=brand["details"],
            created_at=datetime.datetime.now(),
            updated_at=datetime.datetime.now()
        )

    print("Brand created successfully.")
    

def create_categories():
    categories = [
        {
            "name": "Running Shoes",
            "img": "/brand/running_shoes.jpg",
            "details": "Footwear designed for running enthusiasts"
        },
        {
            "name": "Laptops",
            "img": "/brand/laptops.jpg",
            "details": "Powerful and sleek laptops for professionals"
        },
        {
            "name": "Fitness Apparel",
            "img": "/brand/fitness_apparel.jpg",
            "details": "Stylish and comfortable workout clothing"
        },
        {
            "name": "Fresh Produce",
            "img": "/brand/fresh_produce.jpg",
            "details": "A variety of fresh fruits and vegetables"
        },
        {
            "name": "Dairy & Eggs",
            "img": "/brand/dairy_eggs.jpg",
            "details": "Milk, cheese, yogurt, and eggs"
        },
        {
            "name": "Bakery",
            "img": "/brand/bakery.jpg",
            "details": "Freshly baked bread, pastries, and cakes"
        },
        {
            "name": "Meat & Seafood",
            "img": "/brand/meat_seafood.jpg",
            "details": "Various cuts of meat and fresh seafood"
        },
        {
            "name": "Canned Goods",
            "img": "/brand/canned_goods.jpg",
            "details": "Canned vegetables, fruits, and soups"
        },
        {
            "name": "Frozen Foods",
            "img": "/brand/frozen_foods.jpg",
            "details": "Frozen meals, vegetables, and desserts"
        },
        {
            "name": "Snacks",
            "img": "/brand/snacks.jpg",
            "details": "Chips, crackers, nuts, and other snack items"
        },
        {
            "name": "Beverages",
            "img": "/brand/beverages.jpg",
            "details": "Soft drinks, juices, water, and other drinks"
        },
        {
            "name": "Condiments & Sauces",
            "img": "/brand/condiments_sauces.jpg",
            "details": "Sauces, dressings, spices, and condiments"
        },
        {
            "name": "Grains & Pasta",
            "img": "/brand/grains_pasta.jpg",
            "details": "Rice, pasta, oats, and other grains"
        },
        {
            "name": "Household Essentials",
            "img": "/brand/household_essentials.jpg",
            "details": "Cleaning supplies, paper products, and other household necessities"
        },
        {
            "name": "Health & Wellness",
            "img": "/brand/health_wellness.jpg",
            "details": "Vitamins, supplements, and health-related products"
        },
        {
            "name": "Baby & Toddler",
            "img": "/brand/baby_toddler.jpg",
            "details": "Diapers, baby food, and other essentials for infants and toddlers"
        },
        {
            "name": "International Foods",
            "img": "/brand/international_foods.jpg",
            "details": "Ethnic foods, spices, and ingredients from around the world"
        },
        {
            "name": "Organic & Natural",
            "img": "/brand/organic_natural.jpg",
            "details": "Organic produce, natural snacks, and eco-friendly products"
        },
        {
            "name": "Pet Supplies",
            "img": "/brand/pet_supplies.jpg",
            "details": "Food, treats, and accessories for pets"
        },
        {
            "name": "Household Appliances",
            "img": "/brand/household_appliances.jpg",
            "details": "Small appliances for the kitchen and home"
        },
        {
            "name": "Baking Ingredients",
            "img": "/brand/baking_ingredients.jpg",
            "details": "Flour, sugar, baking powder, and other baking essentials"
        },
        {
            "name": "Ready-to-Eat Meals",
            "img": "/brand/ready_to_eat_meals.jpg",
            "details": "Prepared meals, salads, and sandwiches"
        },
        {
            "name": "Specialty Cheeses",
            "img": "/brand/specialty_cheeses.jpg",
            "details": "Gourmet cheeses from around the world"
        }
    ]

    for category in categories:
        Category.objects.create(
            name=category["name"],
            img=category["img"],
            created_at=datetime.datetime.now(),
            updated_at=datetime.datetime.now()
        )

    print("Category created successfully.")

def create_products():
    products = [
    {
        'title': 'Nike Air Zoom Pegasus 38',
        'slug': 'nike-air-zoom-pegasus-38',
        'short_details': 'Versatile and fast. The Nike Air Zoom Pegasus 38 is ready for any workout.',
        'price': '120.00',
        'points': 150,
        'discount': False,
        'previous_price': None,
        'stock_count': 200,
        "image": "product_images/04.jpg",
        'rating': 3.9,
        'remark': 'popular',
        'category_id': 1,
        'brand_id': 1,
        'status': 'active',
        'details': 'The Nike Air Zoom Pegasus 38 continues to put a spring in your step, using the same responsive foam as its predecessor.',
        'color': 'Black,White,Red',
        'size': 'sm, m , l ,xl',
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Apple AirPods Pro',
        'slug': 'apple-airpods-pro',
        'short_details': 'Immerse yourself in the clear, dynamic sound of the Apple AirPods Pro.',
        'price': '249.00',
        'points': 200,
        'discount': True,
        'previous_price': '399.00',
        "image": "product_images/06.jpg",
        'stock_count': 150,
        'rating': 4.7,
        'remark': 'new',
        'category_id': 2,
        'brand_id': 2,
        'status': 'active',
        'details': 'The Apple AirPods Pro feature Active Noise Cancellation for immersive sound.',
        'color': 'Black,White,Red',
        'size': 'sm, m , l ,xl',
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Samsung Galaxy Watch 4',
        'slug': 'samsung-galaxy-watch-4',
        'short_details': 'Track your fitness goals and stay connected with the Samsung Galaxy Watch 4.',
        'price': '299.99',
        'points': 180,
        'discount': False,
        'previous_price': None,
        'stock_count': 100,
        "image": "product_images/09.jpg",
        'rating': 1.6,
        'remark': 'top',
        'category_id': 3,
        'brand_id': 3,
        'status': 'active',
        'details': 'The Samsung Galaxy Watch 4 features advanced health monitoring and fitness tracking.',
        'color': 'Silver',
        'size': 'Large',
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Sony WH-1000XM4 Wireless',
        'slug': 'sony-wh-1000xm4-wireless-headphones',
        'short_details': 'Experience industry-leading noise cancellation with the Sony WH-1000XM4.',
        'price': '349.99',
        'points': 220,
        'discount': True,
        'previous_price': '399.99',
        "image": "product_images/11.jpg",
        'stock_count': 80,
        'rating': 2.8,
        'remark': 'popular',
        'category_id': 4,
        'brand_id': 4,
        'status': 'active',
        'details': 'The Sony WH-1000XM4 headphones deliver stunning sound quality and long-lasting comfort.',
        'color': 'Black',
        'size': None,
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Dell XPS 13 Laptop',
        'slug': 'dell-xps-13-laptop',
        'short_details': 'Powerful performance in a sleek design. The Dell XPS 13 is the ultimate ultrabook.',
        'price': '1199.99',
        'points': 250,
        'discount': False,
        'previous_price': None,
        "image": "product_images/06.jpg",
        'stock_count': 120,
        'rating': 4.9,
        'remark': 'special',
        'category_id': 5,
        'brand_id': 5,
        'status': 'active',
        'details': 'The Dell XPS 13 features a stunning InfinityEdge display and powerful Intel Core processor.',
        'color': 'Silver',
        'size': '13.4-inch',
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Canon EOS Rebel T7i DSLR',
        'slug': 'canon-eos-rebel-t7i-dslr-camera',
        'short_details': 'Capture stunning photos and videos with the Canon EOS Rebel T7i.',
        'price': '799.00',
        'points': 180,
        'discount': False,
        'previous_price': None,
        "image": "product_images/12.jpg",
        'stock_count': 100,
        'rating': 4.7,
        'remark': 'popular',
        'category_id': 6,
        'brand_id': 6,
        'status': 'active',
        'details': 'The Canon EOS Rebel T7i features a 24.2 Megapixel CMOS sensor and fast autofocus system.',
        'color': 'Black,White,Red',
        'size': 'sm, m , l ,xl',
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Fitbit Charge 5 Fitness ',
        'slug': 'fitbit-charge-5-fitness-tracker',
        'short_details': 'Track your fitness and health goals with the Fitbit Charge 5.',
        'price': '179.95',
        'points': 150,
        'discount': True,
        'previous_price': '259.95',
        'image': 'product_images/04.jpg',
        'stock_count': 120,
        'rating': 4.5,
        'remark': 'new',
        'category_id': 7,
        'brand_id': 7,
        'status': 'active',
        'details': 'The Fitbit Charge 5 offers advanced health metrics and up to 7-day battery life.',
        'color': 'Black,White,Red',
        'size': 'sm, m , l ,xl',
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'LG C1 65" OLED 4K TV',
        'slug': 'lg-c1-65-inch-oled-4k-tv',
        'short_details': 'Experience stunning picture quality with the LG C1 OLED 4K TV.',
        'price': '2499.99',
        'points': 250,
        'discount': False,
        'previous_price': None,
        'image': 'product_images/06.jpg',
        'stock_count': 50,
        'rating': 4.9,
        'remark': 'top',
        'category_id': 8,
        'brand_id': 8,
        'status': 'active',
        'details': 'The LG C1 OLED TV features self-lit pixels for perfect black and intense color.',
        'color': 'Black',
        'size': '65-inch',
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Instant Pot Pressure Cooker',
        'slug': 'instant-pot-duo-evo-plus-pressure-cooker',
        'short_details': 'Cook your favorite meals faster and easier with the Instant Pot Duo Evo Plus.',
        'price': '139.99',
        'points': 120,
        'discount': True,
        'previous_price': '219.99',
        'image': 'product_images/03.jpg',
        'stock_count': 90,
        'rating': 4.6,
        'remark': 'popular',
        'category_id': 9,
        'brand_id': 9,
        'status': 'active',
        'details': 'The Instant Pot Duo Evo Plus features 48 customizable presets and a large LCD display.',
        'color': 'Stainless Steel',
        'size': '6 Quart',
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Nintendo Switch Console',
        'slug': 'nintendo-switch-console',
        'short_details': 'Play your favorite games anytime, anywhere with the Nintendo Switch Console.',
        'price': '299.99',
        'points': 200,
        'discount': False,
        'previous_price': None,
        'image': 'product_images/13.jpg',
        'stock_count': 150,
        'rating': 4.8,
        'remark': 'special',
        'category_id': 10,
        'brand_id': 10,
        'status': 'active',
        'details': 'The Nintendo Switch offers versatile gaming options with its unique hybrid design.',
        'color': 'Black,White,Red',
        'size': 'sm, m , l ,xl',
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Sony PlayStation 5',
        'slug': 'sony-playstation-5',
        'short_details': 'Experience next-gen gaming with the Sony PlayStation 5 console.',
        'price': '499.99',
        'points': 200,
        'discount': False,
        'previous_price': None,
        'image': 'product_images/12.jpg',
        'stock_count': 100,
        'rating': 4.9,
        'remark': 'popular',
        'category_id': 11,
        'brand_id': 11,
        'status': 'active',
        'details': 'The Sony PlayStation 5 features lightning-fast loading, haptic feedback, and 3D audio technology.',
        'color': 'White',
        'size': 'Standard',
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Samsung Galaxy S21 Ultra 5G',
        'slug': 'samsung-galaxy-s21-ultra-5g',
        'short_details': 'Experience the ultimate in smartphone technology with the Samsung Galaxy S21 Ultra 5G.',
        'price': '1199.99',
        'points': 250,
        'discount': False,
        'previous_price': None,
        'image': 'product_images/08.jpg',
        'stock_count': 80,
        'rating': 4.8,
        'remark': 'top',
        'category_id': 12,
        'brand_id': 12,
        'status': 'active',
        'details': 'The Samsung Galaxy S21 Ultra 5G features a stunning 6.8-inch AMOLED display and a powerful camera system.',
        'color': 'Phantom Black',
        'size': '256GB',
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Bose QuietComfort 45 Wireless Headphones',
        'slug': 'bose-quietcomfort-45-wireless-headphones',
        'short_details': 'Immerse yourself in superior sound quality with the Bose QuietComfort 45 Wireless Headphones.',
        'price': '329.99',
        'points': 220,
        'discount': False,
        'previous_price': None,
        'image': 'product_images/02.jpg',
        'stock_count': 100,
        'rating': 4.7,
        'remark': 'popular',
        'category_id': 13,
        'brand_id': 13,
        'status': 'active',
        'details': 'The Bose QuietComfort 45 headphones feature advanced noise cancellation and up to 24 hours of battery life.',
        'color': 'Triple Midnight',
        'size': None,
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Amazon Echo Dot (4th Gen)',
        'slug': 'amazon-echo-dot-4th-gen',
        'short_details': 'Make your home smarter with the Amazon Echo Dot (4th Gen) smart speaker.',
        'price': '49.99',
        'points': 100,
        'discount': True,
        'previous_price': '89.99',
        'image': 'product_images/03.jpg',
        'stock_count': 150,
        'rating': 4.5,
        'remark': 'new',
        'category_id': 14,
        'brand_id': 14,
        'status': 'active',
        'details': 'The Amazon Echo Dot (4th Gen) features improved sound quality and built-in Alexa voice assistant.',
        'color': 'Charcoal',
        'size': None,
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'GoPro HERO10 Black',
        'slug': 'gopro-hero10-black',
        'short_details': 'Capture lifes adventures in stunning detail with the GoPro HERO10 Black action camera.',
        'price': '499.99',
        'points': 180,
        'discount': False,
        'previous_price': None,
        'image': 'product_images/09.jpg',
        'stock_count': 120,
        'rating': 4.9,
        'remark': 'special',
        'category_id': 15,
        'brand_id': 15,
        'status': 'active',
        'details': 'The GoPro HERO10 Black offers 5.3K video recording, improved stabilization, and a new processor for enhanced performance.',
        'color': 'Black',
        'size': None,
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Microsoft Surface Laptop 4',
        'slug': 'microsoft-surface-laptop-4',
        'short_details': 'Experience the perfect balance of performance and style with the Microsoft Surface Laptop 4.',
        'price': '1299.99',
        'points': 200,
        'discount': False,
        'previous_price': None,
        'image': 'product_images/08.jpg',
        'stock_count': 100,
        'rating': 4.8,
        'remark': 'popular',
        'category_id': 16,
        'brand_id': 16,
        'status': 'active',
        'details': 'The Microsoft Surface Laptop 4 features a vibrant PixelSense touchscreen display and all-day battery life.',
        'color': 'Platinum',
        'size': '13.5-inch',
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Fitbit Versa 3 Smartwatch',
        'slug': 'fitbit-versa-3-smartwatch',
        'short_details': 'Stay connected and track your fitness goals with the Fitbit Versa 3 Smartwatch.',
        'price': '229.95',
        'points': 150,
        'discount': True,
        'previous_price': '399.95',
        'image': 'product_images/07.jpg',
        'stock_count': 120,
        'rating': 4.6,
        'remark': 'new',
        'category_id': 17,
        'brand_id': 7,
        'status': 'active',
        'details': 'The Fitbit Versa 3 features built-in GPS, heart rate monitoring, and sleep tracking.',
        'color': 'Midnight,Soft Gold',
        'size': None,
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Samsung Galaxy Tab S7+',
        'slug': 'samsung-galaxy-tab-s7-plus',
        'short_details': 'Unlock your creativity with the Samsung Galaxy Tab S7+ tablet.',
        'price': '849.99',
        'points': 180,
        'discount': False,
        'previous_price': None,
        'image': 'product_images/06.jpg',
        'stock_count': 80,
        'rating': 4.7,
        'remark': 'top',
        'category_id': 18,
        'brand_id': 3,
        'status': 'active',
        'details': 'The Samsung Galaxy Tab S7+ features a stunning 12.4-inch Super AMOLED display and S Pen compatibility.',
        'color': 'Mystic Black',
        'size': '256GB',
        'is_reseller': None,
        'reseller_price': None
    },
    {
        'title': 'Apple Watch Series 7',
        'slug': 'apple-watch-series-7',
        'short_details': 'Stay connected and motivated with the Apple Watch Series 7.',
        'price': '399.00',
        'points': 220,
        'discount': False,
        'previous_price': None,
        'image': 'product_images/04.jpg',
        'stock_count': 100,
        'rating': 4.9,
        'remark': 'popular',
        'category_id': 19,
        'brand_id': 2,
        'status': 'active',
        'details': 'The Apple Watch Series 7 features a larger, more advanced display and new health tracking features.',
        'color': 'Midnight Aluminum',
        'size': '45mm',
        'is_reseller': True,
        'reseller_price': 100
    },
    {
        'title': 'LG OLED C1 55" 4K Smart TV',
        'slug': 'lg-oled-c1-55-inch-4k-smart-tv',
        'short_details': 'Immerse yourself in lifelike visuals with the LG OLED C1 55" 4K Smart TV.',
        'price': '1499.99',
        'points': 250,
        'discount': False,
        'previous_price': None,
        'image': 'product_images/03.jpg',
        'stock_count': 50,
        'rating': 4.8,
        'remark': 'top',
        'category_id': 8,
        'brand_id': 8,
        'status': 'active',
        'details': 'The LG OLED C1 55" 4K Smart TV features Dolby Vision IQ and Dolby Atmos for an immersive viewing experience.',
        'color': 'Black',
        'size': '55-inch',
        'is_reseller': True,
        'reseller_price': 100
    },
    {
     'title': 'Samsung QLED Q80A 65" 4K Smart TV',
     'slug': 'samsung-qled-q80a-65-inch-4k-smart-tv',
     'short_details': 'Experience stunning visuals with the Samsung QLED Q80A 65" 4K Smart TV.',
     'price': '1799.99',
     'points': 300,
     'discount': True,
     'previous_price': '1999.99',
     'image': 'product_images/17.jpg',
     'stock_count': 30,
     'rating': 4.7,
     'remark': 'recommended',
     'category_id': 8,
     'brand_id': 6,
     'status': 'active',
     'details': 'The Samsung QLED Q80A 65" features Quantum HDR and Object Tracking Sound for a cinematic experience.',
     'color': 'Titan Black',
     'size': '65-inch',
     'is_reseller': True,
     'reseller_price': 100
 },
 {
     'title': 'Sony BRAVIA XR A90J 55" OLED 4K TV',
     'slug': 'sony-bravia-xr-a90j-55-inch-oled-4k-tv',
     'short_details': 'Enjoy lifelike clarity with the Sony BRAVIA XR A90J 55" OLED 4K TV.',
     'price': '2299.99',
     'points': 280,
     'discount': True,
     'previous_price': '2499.99',
     'image': 'product_images/19.jpg',
     'stock_count': 20,
     'rating': 4.9,
     'remark': 'top pick',
     'category_id': 8,
     'brand_id': 4,
     'status': 'active',
     'details': 'The Sony BRAVIA XR A90J 55" OLED 4K TV features XR OLED Contrast for exceptional picture quality.',
     'color': 'Charcoal Black',
     'size': '55-inch',
     'is_reseller': True,
     'reseller_price': 100
 },
{
     'title': 'LG NanoCell NANO90 75" 4K Smart TV',
     'slug': 'lg-nanocell-nano90-75-inch-4k-smart-tv',
     'short_details': 'Immerse yourself in vibrant colors with the LG NanoCell NANO90 75" 4K Smart TV.',
     'price': '2499.99',
     'points': 320,
     'discount': False,
     'previous_price': None,
     'image': 'product_images/18.jpg',
     'stock_count': 25,
     'rating': 4.6,
     'remark': 'recommended',
     'category_id': 8,
     'brand_id': 8,
     'status': 'active',
     'details': 'The LG NanoCell NANO90 75" 4K Smart TV features Nano Color technology for enhanced color accuracy.',
     'color': 'Steel Silver',
     'size': '75-inch',
     'is_reseller': True,
     'reseller_price': 200
 },
 {
     'title': 'TCL 6-Series 55" QLED 4K Roku Smart TV',
     'slug': 'tcl-6-series-55-inch-qled-4k-roku-smart-tv',
     'short_details': 'Experience powerful performance with the TCL 6-Series 55" QLED 4K Roku Smart TV.',
     'price': '999.99',
     'points': 220,
     'discount': True,
     'previous_price': '1199.99',
     'image': 'product_images/15.jpg',
     'stock_count': 40,
     'rating': 4.5,
     'remark': 'budget-friendly',
     'category_id': 8,
     'brand_id': 9,
     'status': 'active',
     'details': 'The TCL 6-Series 55" QLED 4K Roku Smart TV features Quantum Dot technology for rich, vibrant colors.',
     'color': 'Midnight Black',
     'size': '55-inch',
     'is_reseller': True,
     'reseller_price': 100
 },
 {
     'title': 'Hisense U8G 65" Quantum Series 4K ULED Android TV',
     'slug': 'hisense-u8g-65-inch-quantum-series-4k-uled-android-tv',
     'short_details': 'Immerse yourself in cinematic visuals with the Hisense U8G 65" Quantum Series 4K ULED Android TV.',
     'price': '1599.99',
     'points': 270,
     'discount': True,
     'previous_price': '1799.99',
     'image': 'product_images/16.jpg',
     'stock_count': 15,
     'rating': 4.7,
     'remark': 'recommended',
     'category_id': 8,
     'brand_id': 10,
     'status': 'active',
     'details': 'The Hisense U8G 65" features Quantum Dot Color and Full Array Local Dimming for exceptional picture quality.',
     'color': 'Carbon Grey',
     'size': '65-inch',
     'is_reseller': True,
     'reseller_price': 1000
 }




]

    for product in products:
        Product.objects.create(
            title=product["title"],
            short_details=product["short_details"],
            price=product["price"],
            points=product["points"],
            discount=product["discount"],
            previous_price=product["previous_price"],
            image=product["image"],
            stock_count=product["stock_count"],
            rating=product["rating"],
            remark=product["remark"],
            category_id=product["category_id"],
            brand_id=product["brand_id"],
            details=product["details"],
            color=product["color"],
            size=product["size"],
            is_reseller=product["is_reseller"],
            reseller_price=product["reseller_price"],
        )
    
    print("Product created successfully.")
