# Generated by Django 4.2.10 on 2024-03-17 10:40

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('stripe_charge_id', models.CharField(max_length=50)),
                ('amount', models.FloatField()),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Payments',
            },
        ),
        migrations.CreateModel(
            name='BkashPaymentRefund',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('originalTrxID', models.CharField(max_length=150)),
                ('refundTrxID', models.CharField(max_length=150)),
                ('transactionStatus', models.CharField(max_length=150)),
                ('amount', models.CharField(max_length=150)),
                ('completedTime', models.CharField(max_length=150)),
                ('currency', models.CharField(max_length=150)),
                ('charge', models.CharField(max_length=150)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Bkash Payment Refund',
            },
        ),
        migrations.CreateModel(
            name='BkashPaymentExecute',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('paymentID', models.CharField(max_length=150)),
                ('createTime', models.CharField(max_length=150)),
                ('updateTime', models.CharField(max_length=150)),
                ('trxID', models.CharField(max_length=150)),
                ('transactionStatus', models.CharField(max_length=150)),
                ('amount', models.CharField(max_length=150)),
                ('currency', models.CharField(max_length=150)),
                ('intent', models.CharField(max_length=150)),
                ('merchantInvoiceNumber', models.CharField(max_length=150)),
                ('customerMsisdn', models.CharField(max_length=150)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Bkash Payment Execute',
            },
        ),
        migrations.CreateModel(
            name='BkashPayment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('paymentID', models.CharField(max_length=150)),
                ('createTime', models.CharField(max_length=150)),
                ('orgName', models.CharField(max_length=150)),
                ('transactionStatus', models.CharField(max_length=150)),
                ('amount', models.CharField(max_length=150)),
                ('currency', models.CharField(max_length=150)),
                ('intent', models.CharField(max_length=150)),
                ('merchantInvoiceNumber', models.CharField(max_length=150)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Bkash Payment',
                'verbose_name_plural': 'Bkash Payments',
            },
        ),
        migrations.CreateModel(
            name='BillingAddress',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=50)),
                ('last_name', models.CharField(max_length=50)),
                ('company_name', models.CharField(blank=True, max_length=50, null=True)),
                ('street_address', models.CharField(max_length=100)),
                ('apartment_address', models.CharField(max_length=100)),
                ('country', django_countries.fields.CountryField(max_length=2)),
                ('city', models.CharField(max_length=150)),
                ('state', models.CharField(max_length=150)),
                ('zip', models.CharField(max_length=100)),
                ('phone', models.CharField(max_length=11)),
                ('email', models.EmailField(max_length=254)),
                ('order_note', models.TextField()),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Billing Address',
            },
        ),
    ]
