# api Views
from django.shortcuts import get_object_or_404, render, redirect
from django.views.decorators.http import require_GET, require_POST 
from django.views.decorators.csrf import csrf_exempt
from ..forms import *
from ..models import *
from apps.helpers import *
from django.http import JsonResponse
from django.db import transaction
import json
from pprint import pprint
from decimal import Decimal
from apps.customers.models import *

@allow_only_POST
def api_order_store_checkout(request):
    if request.user.is_authenticated:
        order_user = request.user
    else:
        order_user = None
    order_form = OrderForm(request.POST)

    order_item_data = json.loads(request.POST.get('order_items', '[]')) 
    order_item_forms = [OrderItemForm(item) for item in order_item_data]

    if order_form.is_valid() and all([form.is_valid() for form in order_item_forms]):

        ## -------------- Database write start-------------
        try:
           
            with transaction.atomic():
                order_form.cleaned_data['user'] = order_user
                order_form.cleaned_data['payment_status'] = "unpaid"
                order_form.cleaned_data['delivery_status'] = "pending"
                order_form.cleaned_data['is_reseller'] = False
                
                order = Order.objects.create(**order_form.cleaned_data)

                subtotal = 0
                items_total = 0
                discount = 0
                total_points = 0
                
                for form in order_item_forms:
                    form.cleaned_data['user'] = order_user
                    form.cleaned_data['order'] = order
                    
                    product = form.cleaned_data['product']
                    quantity = form.cleaned_data['quantity']
                    price = product.price  
                    
                    subtotal += quantity * price
                    items_total += quantity
                    total_points += product.points
   
                    OrderItem.objects.create(**form.cleaned_data)

                order.subtotal = subtotal
                order.items_total = items_total
                order.discount = discount
                order.total_payment = subtotal - discount
                order.total_points = total_points


                if request.user.is_authenticated:
                    user = request.user 

                    referral_amount = 0
                    if user.referral:
                        cus_setting = CusSetting.objects.first()

                        referral_amount = Decimal(order.total_payment) * (cus_setting.referral_commision / Decimal(100))

                        user.referral.amount += referral_amount
                        user.referral.save()

                    user.points += total_points                

                    user.save()


                    order.referral_commision_amount = referral_amount


                order.save()


                
                    
        except Exception as e:
            pprint("order  api post",e)
            return JsonResponse({'success': False, 'errors': str(e)}, status=400)
        ## -------------- Database write End-------------

        return JsonResponse({'success': True, 'message': 'Order Created Successfully ', 'id':order.id }, status=201)
    else:
        order_errors = order_form.get_errors()
        order_item_errors = [form.get_errors() for form in order_item_forms]

        errors = {'form_errors': order_errors, 'other_errors': order_item_errors}

        return JsonResponse({'success': False, 'errors': errors}, status=400)
    




@allow_only_POST
def api_order_reseller_store_checkout(request):
    pprint(request.POST)
    order_form = OrderForm(request.POST)

    order_item_data = json.loads(request.POST.get('order_items', '[]')) 
    order_item_forms = [OrderItemForm(item) for item in order_item_data]

    if order_form.is_valid() and all([form.is_valid() for form in order_item_forms]):

        ## -------------- Database write start-------------
        try:
           
            with transaction.atomic():
                user = request.user 
                order_form.cleaned_data['user'] = request.user
                order_form.cleaned_data['payment_status'] = "unpaid"
                order_form.cleaned_data['delivery_status'] = "pending"
                order_form.cleaned_data['is_reseller'] = True
                
                order = Order.objects.create(**order_form.cleaned_data)

                subtotal = 0
                items_total = 0
                discount = 0
                total_points = 0
                
                for form in order_item_forms:
                    form.cleaned_data['user'] = request.user
                    form.cleaned_data['order'] = order
                    
                    product = form.cleaned_data['product']
                    quantity = form.cleaned_data['quantity']
                    reseller_price = product.reseller_price  
                    
                    subtotal += quantity * reseller_price
                    items_total += quantity
                    total_points += product.points
   
                    OrderItem.objects.create(**form.cleaned_data)

                order.subtotal = subtotal
                order.items_total = items_total
                order.discount = discount
                order.total_payment = subtotal - discount
                order.total_points = total_points


                referral_amount = 0
                if user.referral:
                    cus_setting = CusSetting.objects.first()

                    referral_amount = Decimal(order.total_payment) * (cus_setting.referral_commision / Decimal(100))

                    user.referral.amount += referral_amount
                    user.referral.save()

                user.points += total_points                

                user.save()


                order.referral_commision_amount = referral_amount
                order.save()


                
                    
        except Exception as e:
            pprint("order reseller api post",e)
            return JsonResponse({'success': False, 'errors': str(e)}, status=400)
        ## -------------- Database write End-------------

        return JsonResponse({'success': True, 'message': 'Order Created Successfully ', 'id':order.id }, status=201)
    else:
        order_errors = order_form.get_errors()
        order_item_errors = [form.get_errors() for form in order_item_forms]

        errors = {'form_errors': order_errors, 'other_errors': order_item_errors}

        return JsonResponse({'success': False, 'errors': errors}, status=400)
    



@csrf_exempt
@allow_only_GET
def api_order_show(request, order_id):
    try:
        # order = Order.objects.get(id=order_id)
        # order_items = OrderItem.objects.filter(order=order)
        order = Order.objects.select_related('user').prefetch_related('orderitem_set__product').get(id=order_id)

        order_data = serialize_model_data_single(order)
        order_data['order_items'] = serialize_model_data_all(order.orderitem_set.all(),['product'])

        response_data = {'success': True,'data': order_data}
        status_code = 200

    except Order.DoesNotExist:
        response_data = {'success': False,'error': 'Order not found.'}
        status_code = 404

    except Exception as e:
        response_data = {'success': False, 'error': str(e)}
        status_code = 500

    return JsonResponse(response_data, status=status_code ,encoder=CustomJSONEncoder)
