from django.shortcuts import render, redirect, get_object_or_404
from .forms import *
from .models import *
from django.shortcuts import get_object_or_404, render, redirect
from django.views.decorators.http import require_GET, require_POST, require_http_methods
from django.db.models import Count, Q
from taggit.models import Tag
from django.core.paginator import Paginator, EmptyPage, PageNotAnInteger

#-------------------------products Apps --------------------------------
from apps.products.models import *




# Create your views here.
def index(request):
    products = Product.objects.all().order_by('?')
    categories = Category.objects.all().order_by('-id')[:10][::-1]
    new_products = Product.objects.filter(remark='new')
    brands = Brand.objects.all().order_by('?')

    context = {
        'products':products,
        'categories':categories,
        'new_products':new_products,
        'brands':brands,
    }
    return render(request, 'site/page/index.html',context)


def category_detail(request, category_id):
    category = get_object_or_404(Category, pk=category_id)
    products = Product.objects.filter(category=category)

    context = {
        'category': category,
        'products': products,
    }

    return render(request, 'site/page/shop/shop.html', context)

def product_details(request,product_id):
    product = get_object_or_404(Product, id=product_id)
    
    related_products = Product.objects.filter(category=product.category).exclude(id=product.id).order_by('?')[:11]
   
    context = {
        'product': product,
        'related_products': related_products,
    }
    return render(request, 'site/page/product_details.html',context)


def contact(request):
    if request.method == 'POST':
        form = ContactForm(request.POST)
        if form.is_valid():
            form.save()
            return redirect('home')
    else:
        form = ContactForm()

    return render(request, 'site/page/contact.html', {'form': form})


def faqs(request):
    faqs = FAQ.objects.all()
    return render(request, 'site/page/faq.html', {'faqs': faqs})


def privacy_policy(request):
    return render(request, 'site/page/privacy.html')


def blog_category_list(request):
    categories = BlogCategory.objects.all()
    return render(request, 'site/page/blog/category_list.html', {'categories': categories})


def blog_list(request):
    blogs = Blog.objects.all()
    top_categories = BlogCategory.objects.annotate(blog_count=Count('blog')).order_by('-blog_count')[:5]

    # Fix: Use Blog.tags.most_common() to get most common tags associated with blog posts
    popular_tags = Tag.objects.annotate(blog_count=Count('taggit_taggeditem_items')).order_by('-blog_count')[:5]

    popular_feeds = Blog.objects.order_by('-views')[:5]
    social_media = SocialMedia.objects.all()

    # Filtering by the number of items to show
    show_count = request.GET.get('show_count', 12)
    blogs = blogs[:int(show_count)]

    # Sorting by the selected option
    sort_option = request.GET.get('sort_option', 'default')
    if sort_option == 'recent':
        blogs = blogs.order_by('-publish_date')
    elif sort_option == 'featured':
        blogs = blogs.filter(is_featured=True)
    elif sort_option == 'recommend':
        blogs = blogs.filter(is_recommend=True)

    # Searching by query parameter 'q' in title or content
    search_query = request.GET.get('q', '')
    if search_query:
        blogs = blogs.filter(Q(title__icontains=search_query) | Q(content__icontains=search_query))

    # Pagination
    page = request.GET.get('page', 1)
    paginator = Paginator(blogs, 10)  # Show 10 blogs per page

    try:
        blogs = paginator.page(page)
    except PageNotAnInteger:
        blogs = paginator.page(1)
    except EmptyPage:
        blogs = paginator.page(paginator.num_pages)

    context = {
        'blogs': blogs,
        'top_categories': top_categories,
        'popular_tags': popular_tags,
        'popular_feeds': popular_feeds,
        'social_media': social_media,
        'search_query': search_query,
    }

    return render(request, 'site/page/blog_grid.html', context)


def blog_standard(request):
    return render(request, 'site/page/blog_standard.html')


def blog_details(request, slug):
    blog = get_object_or_404(Blog, slug=slug)
    blog.views += 1
    blog.save() 
    comments = blog.comments()

    # Get the next and previous blog posts
    next_blog = Blog.objects.filter(publish_date__gt=blog.publish_date).order_by('publish_date').first()
    prev_blog = Blog.objects.filter(publish_date__lt=blog.publish_date).order_by('-publish_date').first()

    comment_form = CommentForm()

    if request.method == 'POST':
        comment_form = CommentForm(request.POST)
        if comment_form.is_valid():
            comment = comment_form.save(commit=False)
            comment.blog = blog
            comment.user = request.user
            comment.save()
            return redirect('blog_detail', slug=blog.slug)

    context = {
        'blog': blog,
        'next_blog': next_blog,
        'prev_blog': prev_blog,
        'comments': comments
    }

    return render(request, 'site/page/blog_details.html', context)


def reply_to_comment(request, comment_id):
    comment = get_object_or_404(Comment, id=comment_id)
    reply_form = ReplyForm()
    comments = Comment.objects.filter(blog=comment.blog)
    next_blog = Blog.objects.filter(publish_date__gt=comment.blog.publish_date).order_by('publish_date').first()
    prev_blog = Blog.objects.filter(publish_date__lt=comment.blog.publish_date).order_by('-publish_date').first()

    if request.method == 'POST':
        reply_form = ReplyForm(request.POST)
        if reply_form.is_valid():
            reply = reply_form.save(commit=False)
            reply.comment = comment
            reply.user = request.user
            reply.save()
            return redirect('blog_detail', slug=comment.blog.slug)
        
    context = {
        'blog': comment.blog, 
        'comments': comments,
        'next_blog': next_blog,
        'prev_blog': prev_blog,
        }

    return render(request, 'site/page/blog_detail.html', context)


def about(request):
    return render(request, 'site/page/about.html')


def all_category(request):
    return render(request, 'site/page/all_category.html')




from django.core.paginator import Paginator, EmptyPage, PageNotAnInteger

def shop(request):
    products = Product.objects.all()
    
    paginator = Paginator(products, 15)  # Show 5 products per page

    page = request.GET.get('page')
    try:
        paginated_products = paginator.page(page)
    except PageNotAnInteger:
        # If page is not an integer, deliver first page.
        paginated_products = paginator.page(1)
    except EmptyPage:
        # If page is out of range (e.g. 9999), deliver last page of results.
        paginated_products = paginator.page(paginator.num_pages)

    return render(request, 'site/page/shop/shop.html', {'products': paginated_products})



def brand_single(request):
    return render(request, 'site/page/brand_single.html')


def brand_list(request):
    return render(request, 'site/page/brand_list.html')



@require_GET
def contact_list(request):
    contacts = Contact.objects.all()
    return render(request, 'panel/page/contact/contact_list.html', {'contacts': contacts})

@require_GET
def contact_detail(request, contact_id):
    contact = get_object_or_404(Contact, pk=contact_id)
    return render(request, 'panel/page/contact/contact_detail.html', {'contact': contact})

@require_POST
def contact_delete(request, contact_id):
    if request.method == 'POST':
        contact = Contact.objects.get(id=contact_id)
        contact.delete()
    return redirect('contact_list')


@require_GET
def product_slider_index(request):
    product_sliders = ProductSlider.objects.all()
    return render(request, 'panel/page/product_slider/product_slider_list.html', {'product_sliders': product_sliders})

@require_GET
def product_slider_create(request):
    form = ProductSliderForm()
    return render(request, 'panel/page/product_slider/add_product_slider.html', {'form': form})

@require_POST
def product_slider_store(request):
    form = ProductSliderForm(request.POST, request.FILES)
    if form.is_valid():
        product_slider = form.save()
        return redirect('product_slider_show', product_slider_id=product_slider.id)
    return render(request, 'panel/page/product_slider/add_product_slider.html', {'form': form})

@require_GET
def product_slider_show(request, product_slider_id):
    product_slider = get_object_or_404(ProductSlider, pk=product_slider_id)
    return render(request, 'panel/page/product_slider/product_slider_show.html', {'product_slider': product_slider})

@require_GET
def product_slider_edit(request, product_slider_id):
    product_slider = get_object_or_404(ProductSlider, pk=product_slider_id)
    form = ProductSliderForm(instance=product_slider)
    return render(request, 'panel/page/product_slider/edit_product_slider.html', {'form': form, 'product_slider': product_slider})

@require_POST
def product_slider_update(request, product_slider_id):
    product_slider = get_object_or_404(ProductSlider, pk=product_slider_id)
    form = ProductSliderForm(request.POST, request.FILES, instance=product_slider)
    if form.is_valid():
        form.save()
        return redirect('product_slider_show', product_slider_id=product_slider.id)
    return render(request, 'panel/page/product_slider/edit_product_slider.html', {'form': form, 'product_slider': product_slider})

@require_POST
def product_slider_destroy(request, product_slider_id):
    product_slider = get_object_or_404(ProductSlider, pk=product_slider_id)
    product_slider.delete()
    return redirect('product_slider_index')
