from django import forms
from .models import *


#create forms here
class ContactForm(forms.ModelForm):
    class Meta:
        model = Contact
        fields = ['name', 'email', 'subject', 'message']


class CommentForm(forms.ModelForm):
    class Meta:
        model = Comment
        fields = ['text']


class ReplyForm(forms.ModelForm):
    class Meta:
        model = Reply
        fields = ['text']




class ProductSliderForm(forms.ModelForm):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        for field_name, field in self.fields.items():

            if isinstance(field, forms.ImageField):
                field.widget.attrs.update({'class': 'img-class'})  
            if isinstance(field, forms.ChoiceField): 
                field.widget.attrs.update({'class': 'choice-class'})


    class Meta:
        model = ProductSlider
        fields = '__all__'