from django.urls import path
from .views import *

urlpatterns = [
    # Read All
    path('coupons/', coupon_index, name='coupon_index'),

    # Create
    path('coupons/create/', coupon_create, name='coupon_create'),
    path('coupons/store/', coupon_store, name='coupon_store'),

    # Read one
    path('coupons/<int:coupon_id>/', coupon_show, name='coupon_show'),

    # Update
    path('coupons/<int:coupon_id>/edit/', coupon_edit, name='coupon_edit'),
    path('coupons/<int:coupon_id>/update/', coupon_update, name='coupon_update'),

    # Delete
    path('coupons/<int:coupon_id>/destroy/', coupon_destroy, name='coupon_destroy'),




    # Read All
    path('customers/', customer_index, name='customer_index'),

    # Create
    path('customers/create/', customer_create, name='customer_create'),
    path('customers/store/', customer_store, name='customer_store'),

    # Read one
    path('customers/<int:customer_id>/', customer_show, name='customer_show'),

    # Update
    path('customers/<int:customer_id>/edit/', customer_edit, name='customer_edit'),
    path('customers/<int:customer_id>/update/', customer_update, name='customer_update'),

    # Delete
    path('customers/<int:customer_id>/destroy/', customer_destroy, name='customer_destroy'),
    
    
    # ******************** winners url ********************
    
    
    # Read All
    path('winners/', winner_index, name='winner_index'),

    # Create
    path('winners/create/', winner_create, name='winner_create'),
    path('winners/store/', winner_store, name='winner_store'),

    # Read one
    path('winners/<int:winner_id>/', winner_show, name='winner_show'),

    # Update
    path('winners/<int:winner_id>/edit/', winner_edit, name='winner_edit'),
    path('winners/<int:winner_id>/update/', winner_update, name='winner_update'),

    # Delete
    path('winners/<int:winner_id>/destroy/', winner_destroy, name='winner_destroy'),




    # Read All
    path('withdraw/', withdraw_index, name='withdraw_index'),

    # Create
    path('withdraw/create/', withdraw_create, name='withdraw_create'),
    path('withdraw/store/', withdraw_store, name='withdraw_store'),

    # Read one
    path('withdraw/<int:withdraw_id>/show/', withdraw_show, name='withdraw_show'),

    # Update
    path('withdraw/<int:withdraw_id>/edit/', withdraw_edit, name='withdraw_edit'),
    path('withdraw/<int:withdraw_id>/update/', withdraw_update, name='withdraw_update'),

    # Delete
    path('withdraw/<int:withdraw_id>/destroy/', withdraw_destroy, name='withdraw_destroy'),



    path('referral-list/', referral_list, name='referral_list'),
    
    path('referral/<int:referral_id>/show/', referral_show, name='referral_show'),





    path('points/', customers_point_index, name='customers_point_index'),

    path('referrals/', customers_referral_index, name='customers_referral_index'),

    path('referrals/order/', customers_referral_order, name='customers_referral_order'),



    path('referrals/withdraw/', customers_referral_withdraw_list, name='customers_referral_withdraw_list'),
    path('referrals/withdraws/create/', customers_referral_withdraw_create, name='customers_referral_withdraw_create'),
    path('referrals/withdraws/store/', customers_referral_withdraw_store, name='customers_referral_withdraw_store'),
    path('referrals/withdraws/<int:withdraw_id>/show/', customers_referral_withdraw_show, name='customers_referral_withdraw_show'),



# ('pending','Pending'),('processing','Processing'),('completed','Completed'),('cancel','cancel')
    path('orders/', customers_order_list, name='customers_order_list'),
    path('orders/pending', customers_pending_order_list, name='customers_pending_order_list'),
    path('orders/completed', customers_completed_order_list, name='customers_completed_order_list'),

    
    path('open-lottary/', open_lottary, name='open_lottary'),

    path('coupons/<int:coupon_id>/open/', coupon_open, name='coupon_open'),

    path('coupon-list/', customer_coupon_list, name='customer_coupon_list'),





]
