
```py
from django.http import HttpResponse

path('blogs/', blog_list, name='blog_list'),
@require_GET
def blog_list(request):
    return HttpResponse("Blog blog_list")


path('blogs/create/', blog_create, name='blog_create'),
@require_GET
def blog_create(request):
    return HttpResponse("Create Blog")


from pprint import pprint
path('blogs/store/', blog_store, name='blog_store'),
@require_POST
def blog_store(request):
    pprint(request.POST)
    return HttpResponse("Store Blog")


path('blogs/<int:blog_id>/show/', blog_show, name='blog_show'),
@require_GET
def blog_show(request, blog_id):
    return HttpResponse(f"Show Blog with ID: {blog_id}")


path('blogs/<int:blog_id>/edit/', blog_edit, name='blog_edit'),
@require_GET
def blog_edit(request, blog_id):
    return HttpResponse(f"Edit Blog with ID: {blog_id}")
    

from pprint import pprint
path('blogs/<int:blog_id>/update/', blog_update, name='blog_update'),
@require_POST
def blog_update(request, blog_id):
    pprint(request.POST)
    return HttpResponse(f"Update Blog with ID: {blog_id}")


path('blogs/<int:blog_id>/destroy/', blog_destroy, name='blog_destroy'),
@require_POST
def blog_destroy(request, blog_id):
    return HttpResponse(f"Destroy Blog with ID: {blog_id}")

```




**---------------------------------------------------------------------------------------**
**---------------------------------------------------------------------------------------**


for djnago , give me urls, views like below template for "Winner" model

```py

class Winner(models.Model):   # app.customers
    position = models.IntegerField()
    prize = models.CharField(max_length=255)
    prize_given = models.BooleanField(default=False)
    prize_given_to = models.ForeignKey(CustomUser, on_delete=models.RESTRICT)
    prize_given_date = models.DateField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)


```


**urls**
```python
# urls.py
from django.urls import path
from .views import *

urlpatterns = [
    # Read All
    path('blogs/', blog_index, name='blog_index'),

    # Create
    path('blogs/create/', blog_create, name='blog_create'),
    path('blogs/store/', blog_store, name='blog_store'),

    # Read one
    path('blogs/<int:blog_id>/show', blog_show, name='blog_show'),

    # Update
    path('blogs/<int:blog_id>/edit/', blog_edit, name='blog_edit'),
    path('blogs/<int:blog_id>/update/', blog_update, name='blog_update'),

    # Delete
    path('blogs/<int:blog_id>/destroy/', blog_destroy, name='blog_destroy'),
]
```


**views**
```python
# views.py
from django.shortcuts import get_object_or_404, render, redirect
from django.http import HttpResponse
from django.views.decorators.csrf import csrf_exempt
from django.views.decorators.http import require_GET, require_POST
from .forms import *
from .models import *


```

```py
@require_GET
def blog_index(request):
    return HttpResponse("Blog Index")

@require_GET
def blog_create(request):
    return HttpResponse("Create Blog")

@require_POST
def blog_store(request):
    return HttpResponse("Store Blog")

@require_GET
def blog_show(request, blog_id):
    return HttpResponse(f"Show Blog with ID: {blog_id}")

@require_GET
def blog_edit(request, blog_id):
    return HttpResponse(f"Edit Blog with ID: {blog_id}")

@require_POST
def blog_update(request, blog_id):
    return HttpResponse(f"Update Blog with ID: {blog_id}")

@require_POST
def blog_destroy(request, blog_id):
    return HttpResponse(f"Destroy Blog with ID: {blog_id}")

```