from django import forms
from .models import *

class ResellerForm(forms.ModelForm):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        for field_name, field in self.fields.items():

            if isinstance(field, forms.ImageField):
                field.widget.attrs.update({'class': 'img-class'})  
            if isinstance(field, forms.ChoiceField): 
                field.widget.attrs.update({'class': 'choice-class'})

    class Meta:
        model = Reseller
        fields = '__all__'
        exclude = ['user']



class ResellerRequestForm(forms.ModelForm):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        for field_name, field in self.fields.items():

            if isinstance(field, forms.ImageField):
                field.widget.attrs.update({'class': 'img-class'})  
            if isinstance(field, forms.ChoiceField): 
                field.widget.attrs.update({'class': 'choice-class'})

    class Meta:
        model = Reseller
        fields = '__all__'
        exclude = ['user','status']
