from django.shortcuts import render, redirect
from django.contrib.auth import authenticate, login
from django.contrib import messages
from . forms import *
from apps.helpers import *



# Create your views here.

# Create your views here.
@superuser_required
def index(request):

    return render(request, 'panel/dashboard/index.html')

@superuser_required
def customer_index(request):

    return render(request, 'panel/dashboard/customer/index.html')

@superuser_required
def reseller_index(request):

    return render(request, 'panel/dashboard/reseller/index.html')

@superuser_required
def form_layouts(request):

    return render(request, 'panel/page/design_files/form_layouts.html')




def login_view(request):
    if request.method == 'POST':
        phone = request.POST['phone']
        password = request.POST['password']

        remember_me = request.POST.get('check', False)
        
        user = authenticate(request, phone=phone, password=password)

        if user is not None:
            login(request, user)

            if not remember_me:
                request.session.set_expiry(0)

            messages.success(request, "User logged in successfully.")
            return redirect('panel_home')
        else:
            messages.error(request, 'Invalid phone or password.')
            return render(request, 'panel/auth/login.html')
        
    return render(request, 'panel/auth/login.html')