from django.db import models
from apps.products.models import *


from django.contrib.auth import get_user_model
# Create your models here.
CustomUser = get_user_model() 

class Wishlist(models.Model):   # app.orders
    product = models.ForeignKey(Product, on_delete=models.RESTRICT)
    user = models.ForeignKey(CustomUser, on_delete=models.RESTRICT)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class Cart(models.Model):   # app.orders
    user = models.ForeignKey(CustomUser, on_delete=models.RESTRICT)
    product = models.ForeignKey(Product, on_delete=models.RESTRICT)
    color = models.CharField(max_length=200)
    size = models.CharField(max_length=200)
    qty = models.CharField(max_length=200)
    price = models.CharField(max_length=200)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class Order(models.Model):  
    
    is_reseller = models.BooleanField(default=False)

    full_name = models.CharField(max_length=255, verbose_name='Full Name')
    mobile_number = models.CharField(max_length=15, verbose_name='Mobile Number')
    city = models.CharField(max_length=255, verbose_name='City/Municipality',blank = True, null = True)
    area = models.CharField(max_length=255, verbose_name='Area')
    delivery_address = models.TextField(verbose_name='Delivery Address')
    delivery_option = models.CharField(max_length=255, choices=[('cash_in_delivery', 'Cash in Delivery'), ('advance_payment', 'Advance Payment')])

    # New fields
    total_points = models.IntegerField(default=0)
    subtotal = models.DecimalField(max_digits=10, decimal_places=2,default = 0, verbose_name='Delivery Discount', blank = True, null = True)
    items_total = models.IntegerField(default=0)
    discount = models.DecimalField(max_digits=10, decimal_places=2,default = 0, verbose_name='Delivery Discount', blank = True, null = True)
    total_payment = models.DecimalField(max_digits=10, decimal_places=2, verbose_name='Total Payment',default = 0, blank = True, null = True)


    delivery_status = models.CharField(max_length=10, choices=[('pending','Pending'),('processing','Processing'),('completed','Completed'),('cancel','cancel')], default = 'pending' , blank = True , null = True)
    payment_status = models.CharField(max_length=255, choices=[ ('paid','Paid'), ('unpaid', 'Unpaid')], default = 'unpaid', blank = True , null = True)
    user = models.ForeignKey(CustomUser, on_delete=models.SET_NULL, blank = True , null = True)

    used_amount_from_user = models.DecimalField(max_digits=10, decimal_places=2, default=0.0)
    special_discount = models.DecimalField(max_digits=10, decimal_places=2, default=0.0)

    #  the amount that was given to referral from this order
    referral_commision_amount = models.DecimalField(max_digits=10, decimal_places=2, default=0.0)

    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

class OrderItem(models.Model):   # app.orders
    order = models.ForeignKey(Order, on_delete=models.RESTRICT)
    product = models.ForeignKey(Product, on_delete=models.RESTRICT)
    user = models.ForeignKey(CustomUser, on_delete=models.SET_NULL, blank = True , null = True)
    quantity = models.IntegerField(default=0)
    price = models.DecimalField(max_digits=10, decimal_places=2, default= 0)
    points = models.IntegerField(blank = True, null = True, default=0)
    color = models.CharField(max_length=50  , blank = True, null = True)
    size = models.CharField(max_length=50  , blank = True, null = True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)