# Generated by Django 4.2.10 on 2024-03-17 10:40

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('products', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_reseller', models.BooleanField(default=False)),
                ('full_name', models.CharField(max_length=255, verbose_name='Full Name')),
                ('mobile_number', models.CharField(max_length=15, verbose_name='Mobile Number')),
                ('city', models.CharField(blank=True, max_length=255, null=True, verbose_name='City/Municipality')),
                ('area', models.CharField(max_length=255, verbose_name='Area')),
                ('delivery_address', models.TextField(verbose_name='Delivery Address')),
                ('delivery_option', models.CharField(choices=[('cash_in_delivery', 'Cash in Delivery'), ('advance_payment', 'Advance Payment')], max_length=255)),
                ('total_points', models.IntegerField(default=0)),
                ('subtotal', models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=10, null=True, verbose_name='Delivery Discount')),
                ('items_total', models.IntegerField(default=0)),
                ('discount', models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=10, null=True, verbose_name='Delivery Discount')),
                ('total_payment', models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=10, null=True, verbose_name='Total Payment')),
                ('delivery_status', models.CharField(blank=True, choices=[('pending', 'Pending'), ('processing', 'Processing'), ('completed', 'Completed'), ('cancel', 'cancel')], default='pending', max_length=10, null=True)),
                ('payment_status', models.CharField(blank=True, choices=[('paid', 'Paid'), ('unpaid', 'Unpaid')], default='unpaid', max_length=255, null=True)),
                ('used_amount_from_user', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('special_discount', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('referral_commision_amount', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Wishlist',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to='products.product')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='OrderItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity', models.IntegerField(default=0)),
                ('price', models.DecimalField(decimal_places=2, default=0, max_digits=10)),
                ('points', models.IntegerField(blank=True, default=0, null=True)),
                ('color', models.CharField(blank=True, max_length=50, null=True)),
                ('size', models.CharField(blank=True, max_length=50, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to='orders.order')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to='products.product')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Cart',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('color', models.CharField(max_length=200)),
                ('size', models.CharField(max_length=200)),
                ('qty', models.CharField(max_length=200)),
                ('price', models.CharField(max_length=200)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to='products.product')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
