from django.contrib import admin
from .models import *
from django.utils.html import format_html



# Register your models here.
@admin.register(Contact)
class ContactAdmin(admin.ModelAdmin):
    list_display = ['name', 'email', 'subject']
    search_fields = ['name', 'email']


@admin.register(FAQ)
class FAQAdmin(admin.ModelAdmin):
    list_display = ['question']


@admin.register(ContactInformation)
class ContactInformationAdmin(admin.ModelAdmin):
    list_display = ('phone_number1', 'email1', 'address1', 'address2')
    search_fields = ('phone_number1', 'email1', 'address1',)
    list_filter = ('phone_number1', 'email1',)


@admin.register(SocialMedia)
class SocialMediaAdmin(admin.ModelAdmin):
    list_display = ('name', 'url', 'display_icon')
    search_fields = ('name',)
    list_filter = ('name',)

    def display_icon(self, obj):
        if obj.icon:
            return format_html('<img src="{}" width="30" height="30" />', obj.icon.url)
        else:
            return 'None'
        

@admin.register(BlogCategory)
class BlogCategoryAdmin(admin.ModelAdmin):
    list_display = ('name', 'slug')
    search_fields = ('name', 'slug')
    prepopulated_fields = {'slug': ('name',)}


class AuthorSocialProfileInline(admin.TabularInline):  # or admin.StackedInline
    model = AuthorSocialProfile
    extra = 1


@admin.register(Author)
class AuthorAdmin(admin.ModelAdmin):
    inlines = [AuthorSocialProfileInline]


@admin.register(Blog)
class BlogAdmin(admin.ModelAdmin):
    list_display = ('title', 'author', 'publish_date', 'is_published')
    search_fields = ('title', 'author__user__name')
    list_filter = ('categories', 'tags', 'is_published')
    prepopulated_fields = {'slug': ('title',)}
    date_hierarchy = 'publish_date'


class ReplyInline(admin.TabularInline):
    model = Reply
    extra = 1


@admin.register(Comment)
class CommentAdmin(admin.ModelAdmin):
    inlines = [ReplyInline]



