from django.shortcuts import get_object_or_404, render, redirect,HttpResponse
from django.views.decorators.csrf import csrf_exempt
from django.views.decorators.http import require_GET, require_POST, require_http_methods
from .forms import *
from .models import *
from django.db.models import Count
from random import sample
from django.contrib import messages
from pprint import pprint
from django.db import transaction

@require_GET
def coupon_index(request):
    coupons = Coupon.objects.all()
    return render(request, 'panel/page/coupon/coupon_list.html', {'coupons': coupons})

@require_GET
def coupon_create(request):
    form = CouponForm()
    return render(request, 'panel/page/coupon/add_coupon.html', {'form': form})

@require_POST
def coupon_store(request):
    form = CouponForm(request.POST)
    if form.is_valid():
        coupon = form.save()
        return redirect('coupon_show', coupon_id=coupon.id)
    return render(request, 'panel/page/coupon/add_coupon.html', {'form': form})

@require_GET
def coupon_show(request, coupon_id):
    coupon = get_object_or_404(Coupon, pk=coupon_id)
    return render(request, 'panel/page/coupon/coupon_show.html', {'coupon': coupon})

@require_GET
def coupon_edit(request, coupon_id):
    coupon = get_object_or_404(Coupon, pk=coupon_id)
    form = CouponForm(instance=coupon)
    return render(request, 'panel/page/coupon/edit_coupon.html', {'form': form, 'coupon': coupon})

@require_POST
def coupon_update(request, coupon_id):
    coupon = get_object_or_404(Coupon, pk=coupon_id)
    form = CouponForm(request.POST, instance=coupon)
    if form.is_valid():
        form.save()
        return redirect('coupon_show', coupon_id=coupon.id)
    return render(request, 'panel/page/coupon/edit_coupon.html', {'form': form, 'coupon': coupon})

@require_POST
def coupon_destroy(request, coupon_id):
    coupon = get_object_or_404(Coupon, pk=coupon_id)
    coupon.delete()
    return redirect('coupon_index')





@require_GET
def winner_index(request):
    winners = Winner.objects.all()
    return render(request, 'panel/page/winner/winner_list.html', {'winners': winners})

@require_GET
def winner_create(request):
    form = WinnerForm()
    return render(request, 'panel/page/winner/add_winner.html', {'form': form})

@require_POST
def winner_store(request):
    form = WinnerForm(request.POST)
    if form.is_valid():
        winner = form.save()
        return redirect('winner_show', winner_id=winner.id)
    return render(request, 'panel/page/winner/add_winner.html', {'form': form})

@require_GET
def winner_show(request, winner_id):
    winner = get_object_or_404(Winner, pk=winner_id)
    return render(request, 'panel/page/winner/winner_show.html', {'winner': winner})

@require_GET
def winner_edit(request, winner_id):
    winner = get_object_or_404(Winner, pk=winner_id)
    form = WinnerForm(instance=winner)
    return render(request, 'panel/page/winner/edit_winner.html', {'form': form, 'winner': winner})

@require_POST
def winner_update(request, winner_id):
    winner = get_object_or_404(Winner, pk=winner_id)
    form = WinnerForm(request.POST, instance=winner)
    if form.is_valid():
        form.save()
        return redirect('winner_show', winner_id=winner.id)
    return render(request, 'panel/page/winner/edit_winner.html', {'form': form, 'winner': winner})

@require_POST
def winner_destroy(request, winner_id):
    winner = get_object_or_404(Winner, pk=winner_id)
    winner.delete()
    return redirect('winner_index')






@require_GET
def customer_index(request):
    customers = Customer.objects.select_related('user').all()
    return render(request, 'panel/page/customer/customer_list.html', {'customers': customers})

@require_GET
def customer_create(request):
    form = CustomerForm()
    return render(request, 'panel/page/customer/add_customer.html', {'form': form})

@require_POST
def customer_store(request):
    form = CustomerForm(request.POST)
    if form.is_valid():
        customer = form.save()
        return redirect('customer_show', customer_id=customer.id)
    return render(request, 'panel/page/customer/add_customer.html', {'form': form})

@require_GET
def customer_show(request, customer_id):
    customer = get_object_or_404(Customer, pk=customer_id)
    return render(request, 'panel/page/customer/customer_show.html', {'customer': customer})

@require_GET
def customer_edit(request, customer_id):
    customer = get_object_or_404(Customer, pk=customer_id)
    form = CustomerForm(instance=customer)
    return render(request, 'panel/page/customer/edit_customer.html', {'form': form, 'customer': customer})

@require_POST
def customer_update(request, customer_id):
    customer = get_object_or_404(Customer, pk=customer_id)
    form = CustomerForm(request.POST, instance=customer)
    if form.is_valid():
        form.save()
        return redirect('customer_index')
    return render(request, 'panel/page/customer/edit_customer.html', {'form': form, 'customer': customer})

@require_POST
def customer_destroy(request, customer_id):
    customer = get_object_or_404(Customer, pk=customer_id)
    customer.delete()
    return redirect('customer_index')






@require_GET
def withdraw_index(request):
    withdraws = AmountWithdraw.objects.all()
    pprint(withdraws)
    return render(request, 'panel/page/withdraw/withdraw_list.html', {'withdraws': withdraws})

@require_GET
def withdraw_create(request):
    form = AmountWithdrawForm()
    return render(request, 'panel/page/withdraw/add_withdraw.html', {'form': form})

@require_POST
def withdraw_store(request):
    form = AmountWithdrawForm(request.POST)
    if form.is_valid():
        withdraw = form.save()
        return redirect('withdraw_show', withdraw_id=withdraw.id)
    return render(request, 'panel/page/withdraw/add_withdraw.html', {'form': form})

@require_GET
def withdraw_show(request, withdraw_id):
    withdraw = get_object_or_404(AmountWithdraw, pk=withdraw_id)
    return render(request, 'panel/page/withdraw/withdraw_show.html', {'withdraw': withdraw})

@require_GET
def withdraw_edit(request, withdraw_id):
    withdraw = get_object_or_404(AmountWithdraw, pk=withdraw_id)
    form = AmountWithdrawForm(instance=withdraw)
    return render(request, 'panel/page/withdraw/edit_withdraw.html', {'form': form, 'withdraw': withdraw})

@require_POST
@transaction.atomic
def withdraw_update(request, withdraw_id):
    withdraw = get_object_or_404(AmountWithdraw, pk=withdraw_id)
    form = AmountWithdrawForm(request.POST, instance=withdraw)
    if form.is_valid():
        newwithdraw = form.save(commit=False)
        if not withdraw.is_paid :
            if newwithdraw.status == 'paid':
                user = newwithdraw.user
                user.amount -= newwithdraw.withdraw_amount
                user.save()
                newwithdraw.is_paid = True
        newwithdraw.save()
        return redirect('winner_index')
    return render(request, 'panel/page/withdraw/edit_withdraw.html', {'form': form, 'withdraw': withdraw})

@require_POST
def withdraw_destroy(request, withdraw_id):
    withdraw = get_object_or_404(AmountWithdraw, pk=withdraw_id)
    withdraw.delete()
    return redirect('withdraw_index')



@require_GET
def customers_referral_withdraw_list(request):
    withdraws = AmountWithdraw.objects.filter(user=request.user)
    return render(request, 'site/profile/referral/withdraw/withdraw_list.html', {'withdraws': withdraws})


@require_GET
def customers_referral_withdraw_create(request):
    user = request.user
    form = AmountWithdrawReqForm(user)
    return render(request, 'site/profile/referral/withdraw/add_withdraw.html', {'form': form})


@require_POST
def customers_referral_withdraw_store(request):
    user = request.user
    form = AmountWithdrawReqForm(user, request.POST)
    if form.is_valid():
        withdraw = form.save(commit=False)
        withdraw.user = user
        withdraw.save()
        return redirect('withdraw_index')
    else:
        print(form.errors)
    return render(request, 'site/profile/referral/withdraw/add_withdraw.html', {'form': form})


@require_GET
def customers_referral_withdraw_show(request, withdraw_id):
    withdraw = get_object_or_404(AmountWithdraw, pk=withdraw_id)
    return render(request, 'site/profile/referral/withdraw/withdraw_show.html', {'withdraw': withdraw})




# -------------------------------------------------------------------------------------
# *********************** Custome views ************************************************

@require_GET
def referral_list(request):
    referrals = Customer.objects.all()
    return render(request, 'panel/page/referral/referral_list.html', {'referrals': referrals})

@require_GET
def referral_show(request, referral_id):
    referral = get_object_or_404(Customer, pk=referral_id)
    return render(request, 'panel/page/referral/referral_show.html', {'referral': referral})


@require_GET
def customers_point_index(request):
    customers = Customer.objects.all()
    return render(request, 'site/profile/total_point.html', {'customers': customers})


@require_GET
def customers_referral_index(request):
    referrals = Customer.objects.filter(user__referral = request.user)
    return render(request, 'site/profile/referral/referral_list.html', {'referrals': referrals})

@require_GET
def customers_referral_order(request):
    orders = Order.objects.filter(user__referral = request.user)
    return render(request, 'site/profile/referral/referral_order_list.html', {'orders': orders})




@require_GET
def customers_order_list(request):
    orders = Order.objects.filter(user=request.user).select_related('user').prefetch_related('orderitem_set__product')
    total_order_price = sum(order.total_payment for order in orders)
    total_items = sum(order.items_total for order in orders)

    return render(request, 'site/profile/order/order_list.html', {'orders': orders, 'total_order_price' :total_order_price , 'total_items': total_items})


@require_GET
def customers_pending_order_list(request):
    orders = Order.objects.filter(user=request.user,delivery_status='pending').select_related('user').prefetch_related('orderitem_set__product')
    total_order_price = sum(order.total_payment for order in orders)
    total_items = sum(order.items_total for order in orders)

    return render(request, 'site/profile/order/order_list.html', {'orders': orders, 'total_order_price' :total_order_price , 'total_items': total_items})

@require_GET
def customers_completed_order_list(request):
    orders = Order.objects.filter(user=request.user,delivery_status='completed').select_related('user').prefetch_related('orderitem_set__product')
    total_order_price = sum(order.total_payment for order in orders)
    total_items = sum(order.items_total for order in orders)

    return render(request, 'site/profile/order/order_list.html', {'orders': orders, 'total_order_price' :total_order_price , 'total_items': total_items})


@require_GET
def open_lottary(request):
    coupons = Coupon.objects.filter(opened_by__isnull=True, is_enabled=True).order_by('?')[:30]
    return render(request, 'site/profile/coupon/open_lottary.html', {'coupons': coupons})

@require_GET
def coupon_open(request, coupon_id):
    
    user = request.user
    if user.points < 100:
        messages.error(request, "Insufficient points to open the coupon.")
        return redirect('open_lottary')
    
    coupon = get_object_or_404(Coupon, pk=coupon_id)

    if coupon.opened_by is not None:
        messages.error(request, "Coupon has already been opened.")
        return redirect('open_lottary')

    try:
        with transaction.atomic():

            user.points -= 100
            user.save()

            # Update the coupon fields
            coupon.opened_by = user
            coupon.open_date = timezone.now()  # Assuming you have imported timezone from django.utils
            coupon.save()

    except Exception as e:
        messages.error(request, "Unable to open the coupon.Try again")
        return redirect('open_lottary')
    
    return render(request, 'site/profile/coupon/lottary_result.html',{'coupon': coupon})


@require_GET
def customer_coupon_list(request):
    coupons = Coupon.objects.filter(opened_by=request.user)
    return render(request, 'site/profile/coupon/customer_coupon_list.html', {'coupons': coupons})
