from django.db import models
from apps.orders.models import *
from django.contrib.auth import get_user_model
# Create your models here.
CustomUser = get_user_model() 

class CusSetting(models.Model): 
    coupon_open_point = models.IntegerField(default = 100)
    referral_commision = models.DecimalField(max_digits=5, decimal_places=2, default=20.0)

class Customer(models.Model):
    cus_full_name = models.CharField(max_length=100, blank=True, null=True, verbose_name="Full Name")
    cus_img = models.ImageField(upload_to='customer_images/', blank=True, null=True, verbose_name="Image")
    cus_city = models.CharField(max_length=50, blank=True, null=True, verbose_name="City")
    cus_state = models.CharField(max_length=50, blank=True, null=True, verbose_name="State")
    cus_postcode = models.CharField(max_length=50, blank=True, null=True, verbose_name="Postcode")
    cus_country = models.CharField(max_length=50, blank=True, null=True, verbose_name="Country")

    total_purchase_amount = models.DecimalField(max_digits=10, decimal_places=2, blank=True, null=True, default=0, verbose_name="Total Purchase Amount")
    
    ship_name = models.CharField(max_length=100, blank=True, null=True, verbose_name="Shipping Name")
    ship_add = models.CharField(max_length=100, blank=True, null=True, verbose_name="Shipping Address")
    ship_city = models.CharField(max_length=100, blank=True, null=True, verbose_name="Shipping City")
    ship_state = models.CharField(max_length=100, blank=True, null=True, verbose_name="Shipping State")
    ship_postcode = models.CharField(max_length=100, blank=True, null=True, verbose_name="Shipping Postcode")
    ship_country = models.CharField(max_length=100, blank=True, null=True, verbose_name="Shipping Country")
    ship_phone = models.CharField(max_length=50, blank=True, null=True, verbose_name="Shipping Phone")
    user = models.OneToOneField(CustomUser, on_delete=models.RESTRICT, null=True, blank=True, unique=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)


class Coupon(models.Model):    # app.customers
    prize = models.CharField(max_length=255)
    coupon_code = models.CharField(max_length=255, blank = True, null = True)
    opened_by = models.ForeignKey(CustomUser, on_delete=models.RESTRICT, blank = True, null = True)
    open_date = models.DateField(blank = True, null = True)
    is_enabled = models.BooleanField(default=False)
    prize_paid = models.BooleanField(default=False)
    expiry_date = models.DateField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)



class AmountWithdraw(models.Model):    # app.customers
    withdraw_amount = models.DecimalField(max_digits=10, decimal_places=2, default=0.0)
    withdraw_method = models.CharField(max_length=255, blank = True, null = True)
    status = models.CharField(max_length=255, choices=[('pending', 'Pending'), ('paid', 'Paid'), ('rejected', 'Rejected')], default = 'pending')

    request_date =models.DateTimeField(auto_now_add=True)

    is_paid = models.BooleanField(default=False)

    details = models.TextField(null=True, blank =True)

    user = models.ForeignKey(CustomUser, on_delete=models.RESTRICT)

    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    

class Winner(models.Model):   # app.customers
    position = models.IntegerField()
    prize = models.CharField(max_length=255)
    prize_paid = models.BooleanField(default=False)
    prize_given_to = models.ForeignKey(CustomUser, on_delete=models.RESTRICT)
    prize_given_date = models.DateField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)






# class AmountExpenses(models.Model):   # app.customers
#     is_withdraw = models.BooleanField(default=False)
#     is_purchase = models.BooleanField(default=False)
#     is_done = models.BooleanField(default=False)
#     type = models.CharField(max_length=100, unique=True)
#     user = models.ForeignKey(CustomUser, on_delete=models.RESTRICT)
#     created_at = models.DateTimeField(auto_now_add=True)
#     updated_at = models.DateTimeField(auto_now=True)


# class Commission(models.Model):   # app.customers
#     type = models.CharField(max_length=255)
#     commission_percent = models.DecimalField(max_digits=5, decimal_places=2)
#     commission_amount = models.DecimalField(max_digits=10, decimal_places=2)
#     generation = models.IntegerField()
#     order = models.ForeignKey(Order, on_delete=models.RESTRICT)
#     user = models.ForeignKey(CustomUser, on_delete=models.RESTRICT)
#     created_at = models.DateTimeField(auto_now_add=True)
#     updated_at = models.DateTimeField(auto_now=True)

# class Referral(models.Model):   # app.customers
#     referrer = models.ForeignKey(CustomUser, on_delete=models.CASCADE, related_name='referrals')
#     referee = models.ForeignKey(CustomUser, on_delete=models.CASCADE, related_name='referred_by')
#     level = models.IntegerField()
#     created_at = models.DateTimeField(auto_now_add=True)
#     updated_at = models.DateTimeField(auto_now=True)



