from django.urls import path
from . import views
from .views import *


# app_name = 'accounts'

urlpatterns = [
   path('login/', views.signin, name='login'),
   path('signup/', views.signup, name='signup'),
   path('signout/', views.signout, name='signout'),
   path('profile/', views.profile, name='profile'),
   path('profile/<int:pk>/update/', views.profile_update, name='profile_update'),

   path('profile_back/', views.profile_back, name='profile_back'),

   path('reset-password/', views.password_reset, name='reset_password'),
   path('reset-password-done/', views.password_reset_done, name='reset_password_done'),
   path('reset-password-confirm/<uidb64>/<token>/', views.password_reset_confirm, name='reset_password_confirm'),
   path('reset-password-complete/', views.password_reset_complete, name='password_reset_complete'),



   path('users/', custom_user_list, name='custom_user_list'),

   # Create
   path('users/create/', custom_user_create, name='custom_user_create'),
   path('users/store/', custom_user_store, name='custom_user_store'),

   # Read one
   path('users/<int:user_id>/show/', custom_user_show, name='custom_user_show'),

   # Update
   path('users/<int:user_id>/edit/', custom_user_edit, name='custom_user_edit'),
   path('users/<int:user_id>/update/', custom_user_update, name='custom_user_update'),

   # Delete
   path('users/<int:user_id>/destroy/', custom_user_destroy, name='custom_user_destroy'),

]



